/*****************************************************************************
*  LPC4357 SCT demo program
*
*  Use the match reload registers to change the duty cycle of two PWM
*  signals and maintain their dead-time intervals using the NORELOAD_L bit
*  in the SCT Configuration register
*  Use switch SWP4_0 to change the duty cycle of PWM1 and PWM2
*  SCT_OUT0 (pin P2_8) is PWM1
*  SCT_OUT1 (pin P2_7) is PWM2
*****************************************************************************/
#include "nxp_lpc43xx.h"
#include "mcb4300.h"

extern void SCT_Init(void);

#define hperiod    (180)

void SysTick_Handler(void)
{
    LPC_SCT->CONFIG |= (1 << 7);                       // stop reload process for L counter

    if (SWP4_0)                                        // switch SWP4_0 unpressed?
    {
        if (LPC_SCT->MATCHREL[2].L < hperiod-1)        // yes, check if DC2 < Period of PWM
        {
            LPC_SCT->MATCHREL[1].L ++;                 // increase duty cycle
            LPC_SCT->MATCHREL[2].L ++;
        }
    }
    else if (LPC_SCT->MATCHREL[1].L > 1)               // no, check if DC1 > 1
    {
        LPC_SCT->MATCHREL[1].L --;                     // decrease duty cycle
        LPC_SCT->MATCHREL[2].L --;
    }
    LPC_SCT->CONFIG &= ~(1 << 7);                      // enable reload process for L counter
}

int main (void)
{
    SystemCoreClockUpdate ();                          // update system core clock

    LPC_CCU1->CLK_M4_SCT_CFG  = (1 << 0);              // enable SCT clock in CCU1 

    SysTick_Config(SystemCoreClock/50);                // SysTick interrupt @ 50 Hz = 20 msec
    MCB4300_Init();                                    // Initialize MCB4300 board stuff
    SCT_Init();                                        // Initialize SCT

    while (1)                                          // loop forever
    {
    }
}
